<?php

namespace App\Http\Resources;

use App\helpers\Attachment;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\Api\vendor\ProductResource;
use Carbon\Carbon;

class OrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'branch' => $this->branch,
            'user' => $this->user,
            'order_type' => $this->order_type,
            'total_price' => Attachment::convertPrice($this->price),
            'status' => $this->status,
            'payment_method' => $this->payment_method,
            'bank_image' => MediaResource::make($this->image),
            'created_at' => Carbon::parse($this->created_at)->format('Y-m-d'),
            'product' => $this->when($this->order_type == 'rfq_order' , $this->whenLoaded('product', function () {
                return [
                    'id' => $this->product->id,
                    'name' => $this->product->name,
                    'image' => MediaResource::make($this->product->image), // Accessor for image
                ];
            })),
            'order_items' => OrderItemResource::collection($this->rfqItems), // Using the OrderItemResource
        ];
    }
}
