<?php

namespace Database\Seeders;

use App\Models\Country;
use Illuminate\Database\Seeder;
use App\Models\CountryTranslation;

class CountrySeeder extends Seeder
{
    public function run(): void
    {
        $countries = [
            "EG" => [
                "name_en" => "Egypt",
                "name_ar" => "مصر",
                "currency_en" => "EGP",
                "currency_ar" => "جنيه مصري",
                "symbol" => "£",
                "calling_code" => "+20"
            ],
        ];


        foreach ($countries as $key => $country) {
            $countryModel = Country::create([
                'abbreviation' => $key,
                'code' => $country['calling_code'],
                'status' => 'active',
                'currency_symbol' => $country['symbol'],
            ]);

            CountryTranslation::create([
                'country_id' => $countryModel->id,
                'locale' => 'en',
                'name' => $country['name_en'],
                'currency' => $country['currency_en'],
            ]);

            CountryTranslation::create([
                'country_id' => $countryModel->id,
                'locale' => 'ar',
                'name' => $country['name_ar'],
                'currency' => $country['currency_ar'],
            ]);
        }


    }
}
