<?php

namespace App\Http\Controllers\Dentist;

use App\Models\Product;
use Illuminate\Http\Request;
use App\Traits\HasCrudActions;
use App\Http\Controllers\Controller;
use App\Http\Resources\Api\Dentist\ProductResource;

class ProductController extends Controller
{
    use HasCrudActions;
    protected $model = Product::class;

    protected $resource = ProductResource::class;

    public function index(Request $request)
    {
        // Use the method to retrieve relations for eager loading
        $searchableFields = [
            'name' => ['name' => $request->name],
        ];
        $modelResource = $this->search()->searchRelated($searchableFields)
            ->with(['mainCategory', 'subCategory', 'attachmentRelation']);
        if ($request->has('top_sold') && $request->top_sold == 1) {
            $modelResource = Product::searchRelated($searchableFields)->with(['mainCategory', 'subCategory', 'attachmentRelation'])
                ->select('products.id', 'products.name', 'products.price', 'products.description', 'products.main_category_id')
                ->leftJoin('rfq_items', 'products.id', '=', 'rfq_items.product_id')
                ->leftJoin('r_f_q_s', 'products.id', '=', 'r_f_q_s.product_id')
                ->selectRaw('COUNT(rfq_items.product_id) + COUNT(r_f_q_s.product_id) as rfq_count')
                ->groupBy('products.id', 'products.name', 'products.price', 'products.description', 'products.main_category_id')
                ->having('rfq_count', '>', 0) // Only get products with a count greater than 0
                ->orderByDesc('rfq_count')
                ->limit(5);
        }

        return $this->apiResponse('200', __('success'), '', ProductResource::collection($modelResource->orderBy('id', 'DESC')->get()));
    }
}
