<?php

namespace App\Http\Controllers\Api\Admin;

use App\Http\Controllers\Controller;
use App\Http\Resources\Api\Admin\BidResource;
use App\Models\RfqBid;
use App\Traits\HasCrudActions;
use Illuminate\Http\Request;

class BidController extends Controller
{
    use HasCrudActions;
    protected $model = RfqBid::class;

    protected $resource = BidResource::class;

    public function index(Request $request)
    {
        $model = app($this->model);
        

        $modelResource = $this->search()->where('rfq_id' , $request->rfq_id);

        return $this->paginatedResponse($modelResource->orderBy('id', 'DESC'));
    }
}
