<?php

namespace App\Http\Controllers\Api\Admin;

use App\Models\Branch;
use Illuminate\Http\Request;
use App\Traits\HasCrudActions;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Admin\BranchRequest;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Resources\Api\Admin\BranchResource;

class BranchController extends Controller
{
    use HasCrudActions;
    protected $model = Branch::class;

    protected $resource = BranchResource::class;

    protected $request = BranchRequest::class;


    public function index(Request $request)
    {
        $model = app($this->model);

        // Use the method to retrieve relations for eager loading
        $relations = method_exists($model, 'getWithRelations') ? $model->getWithRelations() : [];

        $modelResource = $this->search()->where('user_id',$request->user_id)->with($relations);
            return $this->apiResponse('200', __('success'), '', $modelResource->orderBy('id', 'DESC')->get());


    }

    public function destroy(string $id )
    {
        try {
            $record = $this->model::find($id);
            if (!$record) {
                return $this->apiResponse(Response::HTTP_OK, 'fail', __('resource_not_found'));
            }

            DB::beginTransaction();

            if($record->rfq){
                return $this->apiResponse(400, __('fail'), __('cant delete resource'));

            }
            $record->delete();

            DB::commit();

            return $this->apiResponse(Response::HTTP_OK, __('success'), __('deleted successfully'));
        } catch (\Exception $e) {

            DB::rollBack();

            $this->log($id, $this->model, $e->getMessage(),$e);

            return $this->errorMessage($e);
        }
    }

    

}
