<?php

namespace App\Http\Controllers\Api\Admin;

use App\Models\Page;
use Illuminate\Http\Request;
use App\Traits\HasCrudActions;
use App\Models\PageTranslation;
use App\Http\Requests\PageRequest;
use App\Http\Controllers\Controller;
use App\Http\Resources\Api\Admin\PageResource;
use Symfony\Component\HttpFoundation\Response;

class PageController extends Controller
{
    use HasCrudActions;

    protected $model = Page::class;

    protected $resource = PageResource::class;

    protected $request = PageRequest::class;


    public function update(Request $request, $pageId)
    {
      
    
        // Find the page
        $page = Page::findOrFail($pageId);
    
     
    
        // Extract translations from the request
        $translations = [];
        foreach ($request->all() as $key => $value) {
            if (preg_match('/^(\w+)\[(\w+)\]$/', $key, $matches)) {
                $locale = $matches[1]; // Extract locale (e.g., 'ar', 'en')
                $field = $matches[2];  // Extract field (e.g., 'title', 'describtion')
    
                // Group translations by locale
                $translations[$locale][$field] = $value;
            }
        }
    
        // Update translations
        foreach ($translations as $locale => $data) {
            if (isset($data['title'], $data['describtion'])) {
                PageTranslation::updateOrCreate(
                    [
                        'page_id' => $page->id,
                        'locale' => $locale,
                    ],
                    [
                        'title' => $data['title'],
                        'describtion' => $data['describtion'],
                    ]
                );
            }
        }
    
        return $this->apiResponse(Response::HTTP_OK, __('success'), __('Updated Successfully!'), new PageResource($page));

    }
    


}
