<?php

namespace App\Http\Controllers;

use Exception;
use App\Models\RFQ;
use App\Models\Cart;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\PaymobPaymentTracker;

class PaymobWebhookController extends Controller
{
    public function handle(Request $request)
    {
        $data = $request->all();
        Log::info('Payment handle request data:', $data);
        ksort($data);
    
        $specialReference = $data['intention']['special_reference'] ?? null;
        $paymentTracker = PaymobPaymentTracker::where('reference_id', $specialReference)->first();
    
        if (!$paymentTracker) {
            return response()->json(['message' => 'Invalid reference ID'], 404);
        }
    
        // Validate HMAC to ensure the request is authentic
        $hmac = $data['hmac'];
        $arrayRef = [
            'amount_cents', 'created_at', 'currency', 'error_occured', 'has_parent_transaction',
            'id', 'integration_id', 'is_3d_secure', 'is_auth', 'is_capture', 'is_refunded',
            'is_standalone_payment', 'is_voided', 'order', 'owner', 'pending',
            'source_data_pan', 'source_data_sub_type', 'source_data_type', 'success',
        ];
        $connectedString = $this->generateConnectedString($data, $arrayRef);
        $secret = env('PAYMOB_HMAC');
        $hashed = hash_hmac('sha512', $connectedString, $secret);
    
        if ($hashed !== $hmac) {
            return response()->json(['message' => 'Invalid HMAC'], 400);
        }
    
        $isPaymentSuccessful = $data['transaction']['success'] ?? false;
    
        // Update payment tracker and temporary order
        $paymentTracker->update([
            'status' => $isPaymentSuccessful ? 'Success' : 'Failed',
            'message' => $isPaymentSuccessful ? 'Payment successful' : 'Payment failed',
        ]);
    
        $order = RFQ::find($paymentTracker->order_id);
        if ($order) {
            $order->update(['status' => $isPaymentSuccessful ? 'confirmed' : 'cancelled']);
            if ($isPaymentSuccessful) {
                $cart = Cart::where('user_id', $order->user_id)->first();
                if ($cart) {
                    $cart->items()->delete();
                    $cart->delete();
                }
            }
            
        }
    
        return response()->json(['message' => $isPaymentSuccessful ? 'Payment success' : 'Payment failed'], 200);
    }
    
    public function handleSuccessfulPayment(Request $request)
    {
        $data = $request->all();
        Log::info('Payment handle request data:', $data);
        ksort($data);

        $payment_tracker = PaymobPaymentTracker::where('reference_id', $data['merchant_order_id'])->first();
        $payload = json_decode($payment_tracker->payload, true);


            if($payment_tracker->status == 'Success'){
                return view('merchantPayment.success');

            }else{
                return view('merchantPayment.fail');

            }

       

    }

}
