<?php

namespace App\Http\Requests\Api\Admin;

use Illuminate\Foundation\Http\FormRequest;

class SubCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = [
            'name' => ['required', 'string', 'max:255'],
        ];

        if ($this->isMethod('post')) {
            $rules['parent_id'] = ['required', 'exists:categories,id'];
            $rules['main_category_id'] = ['required', 'exists:categories,id'];
            $rules['image'] = ['required'];


        } else {
            $rules['parent_id'] = ['nullable', 'exists:categories,id'];
            $rules['image'] = ['nullable'];

        }

        return $rules;
    }

}
