<?php

    
namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Events\UserNotification;

class PushNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public $notificationData;

    public function __construct($notificationData)
    {
        $this->notificationData = $notificationData;
    }

    public function via($notifiable)
    {
        return ['database', 'broadcast'];
    }

    public function toArray($notifiable)
    {
        return $this->notificationData;
    }

    public function toBroadcast($notifiable)
    {
        // Trigger the event for Pusher
        event(new UserNotification($notifiable->id, $this->notificationData['message']));

        return [
            'title' => $this->notificationData['title'],
            'message' => $this->notificationData['message'],
        ];
    }
}
