<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class UniqueTranslation implements ValidationRule
{
    private $id;      // the id of the updated record
    private $translation_model;
    private $foreign_key;    // the foreign key of the main table.  ie. category_id

    public function __construct($model, $foreign_key, $id)
    {
        $this->id = $id;
        $this->translation_model = new $model();
        $this->foreign_key = $foreign_key;
    }

    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        [$locale, $attr] = explode('.', $attribute, 2);

        $exists = $this->translation_model::where($attr, $value)
            ->where('locale', $locale)
            ->when($this->id, function ($query, $id) {
                $query->where($this->foreign_key, '!=', $id);
            })->exists();

        if ($exists) {
            $fail(__('validation.unique'));
        }
    }
}
