<?php

namespace App\Services;

use Exception;
use GuzzleHttp\Client;
use App\helpers\Common;

use App\Models\Currency;
use Illuminate\Support\Str;
use GuzzleHttp\Psr7\Request;
use App\Models\Wallet\Wallet;
use App\Traits\HasCrudActions;
use App\Models\Deposit\Deposit;
use App\Models\Merchant\Merchant;
use Illuminate\Support\Facades\DB;
use App\Models\PaymobPaymentTracker;
use Illuminate\Support\Facades\Http;
use App\Models\Transaction\Transaction;
use Illuminate\Support\Facades\Session;
use GuzzleHttp\Exception\ClientException;
use App\Models\PaymentMethod\PaymentMethod;
use App\Models\PaymentSession\PaymentSession;
use App\Models\MerchantPayment\MerchantPayment;
use App\Models\CurrencyPaymentMethod\CurrencyPaymentMethod;

class PaymobService
{
    use HasCrudActions;
   
    public $currencyCode;
    public  $paid_amount_eg_pounds;
    public $currency_to_send = 'EGP';

    /**
     * This public Fuction used in Controllers to start a payment with paymob it gets the token then create order then return the token and redirect to paymob page to validate
     *
     * @param object  $credentials  -- stored in db 
     * @param object  $request  -- from user inputs 
     * @param object  $user  -- auth user object
     * @param boolean  $mobile  
     * @param string  $strategy 
     */
    public function createPayment($request, $user, $mobile = false, $strategy = null)
    {
        $reference_id = Str::uuid();
        // Create the payment intention
        $order = $this->createPaymentIntention($request, $user, $reference_id);
        if ($order->getStatusCode() == 404 || $order->getStatusCode() == 401) {
            $orderData = json_decode($order->getContent(), true);
    
            if (isset($orderData['error']['detail'])) {
                $errorDetail = $orderData['error']['detail'];
                return $this->ApiResponse('400', 'failed', '', $errorDetail);
            }
        }
    
        // // Create a payment tracker record
        // $payment_tracker = PaymobPaymentTracker::create([
        //     'reference_id' => $reference_id,
        //     "user_id" => $user->id ?? null,
        //     "amount" => $request->amount,
        //     'status' => 'Pending',
        //     'order_id'
        // ]);
    
        // Get the response data
        $responseData = json_decode($order->getContent(), true);
        $clientSecret = $responseData['data']['client_secret'] ?? null;
        // Retrieve credentials from the .env file
        $paymobPublicKey = env('PAYMOB_PUBLIC_KEY');
    
        // Construct the payment URL
        $payment_url = "https://accept.paymob.com/unifiedcheckout/?publicKey={$paymobPublicKey}&clientSecret={$clientSecret}";
    
        return $payment_url;
    }
    

    
    public function createPaymentIntention($request, $user, $reference_id)
    {
        // Get exchange rate from .env or default fallback
        $currency_to_send = 'EGP';
    
        // Calculate amount in Egyptian Pounds
      
            $this->paid_amount_eg_pounds = (float)$request['amount'] * 100;
        
    
        // Retrieve credentials from the .env file
        $secret_key = env('PAYMOB_SECRET_KEY');
        $integration_id = env('PAYMOB_INTEGRATION_ID');
        $integration_name = env('PAYMOB_INTEGRATION_NAME');
    
        if (!$secret_key || !$integration_id || !$integration_name) {
            throw new Exception('Paymob credentials are not properly configured in the environment.');
        }
        dd($secret_key);
        // Define the endpoint and request headers
        $headers = [
            'Authorization' => 'Token ' . $secret_key,
            'Content-Type' => 'application/json',
        ];
    
        // Define the callback URLs
        $notificationUrl = "https://roughy-dynamic-usually.ngrok-free.app/Paymob/webhook";
        $redirectionUrl = "http://127.0.0.1:8000/Paymob/callback";
        // Prepare the data payload
        $body = json_encode([
            "amount" => $this->paid_amount_eg_pounds,
            "currency" => $currency_to_send,
            "payment_methods" => ["$integration_name"],
            "billing_data" => [
                "apartment" => "6",
                "first_name" => $user->owner_name,
                "last_name" => $user->owner_name,
                "phone_number" => $user->mobile,
                "country" => $user->country?->name,
                "email" => $user->email,
                "floor" => "1",
                "state" => "Alkhuwair"
            ],
            "special_reference" => $reference_id,
            "notification_url" => $notificationUrl,
            "redirection_url" => $redirectionUrl
        ]);
    
        // Create a new Guzzle HTTP client
        $client = new Client();
    
        try {
            // Create and send the Guzzle request
            $request = new Request('POST', 'https://accept.paymob.com/v1/intention/', $headers, $body);
            $res = $client->sendAsync($request)->wait();
    
            // Decode the response body
            $responseBody = json_decode($res->getBody(), true);
            // Return the response body directly as an array
            return response()->json([
                'status' => 'success',
                'message' => 'success',
                'data' => $responseBody,
            ], 200);
    
        } catch (ClientException $e) {
            // Log the error for debugging purposes
            \Log::error('Payment intention creation failed: ' . $e->getMessage());
    
            // Decode and capture the error response
            $errorResponse = json_decode($e->getResponse()->getBody()->getContents(), true);
            $errorDetail = $errorResponse['detail'] ?? 'An error occurred';
            // Return a structured error response
            return response()->json([
                'status' => 'error',
                'message' => 'Failed to create payment intention',
                'error' => [
                    'detail' => $errorDetail
                ]
            ], $e->getCode());
        }
    }
    
    
  

 



}
