<?php

namespace App\Traits;

use App\Models\Permission\Group;
use App\Models\Permission\Permission;

trait HasPermission {

    public function group()
    {
        return $this->belongsTo(Group::class);
    }

    public function permissions()
    {
        return $this->morphToMany(Permission::class, 'user_permission', 'user_id', 'permission_id');
    }

    public function hasPermissionTo($permission){
        $permission = $this->permissions()->where('name', $permission)->first();
        if($permission){
            return true;
        }

        return false;
    }
}
