<?php

namespace App\Http\Controllers\Api\Admin;

use App\Models\Category;
use Illuminate\Http\Request;
use App\Traits\HasCrudActions;
use App\Http\Controllers\Controller;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Requests\Api\Admin\CategoryRequest;
use App\Http\Resources\Api\Admin\CategoryResource;

class CategoryController extends Controller
{
    use HasCrudActions;

    protected $model = Category::class;

    protected $resource = CategoryResource::class;

    protected $request = CategoryRequest::class;


    public function index()
    {
        $modelResource = $this->search();

        return $this->ApiResponse('200', __('success'), '', CategoryResource::collection($modelResource->whereNull('parent_id')->orderBy('id' , 'DESC')->with('children')->get()));

    }

    public function show(string $id)
    {
        $record = $this->model::find($id)->load('children');

        if (!$record) {
            return $this->apiResponse(Response::HTTP_OK, 'fail', __('resource not found'));
        }

        $recordResource = new $this->resource($record);

        return $this->apiResponse(Response::HTTP_OK, __('success'), '', $recordResource);
    }

}
