<?php

namespace App\Http\Controllers\Api\Dentist;

use App\Models\RFQ;
use App\Models\RfqBid;
use Illuminate\Http\Request;
use App\Traits\HasCrudActions;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\Api\Dentist\RfqRequest;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Resources\Api\Dentist\RfqResource;
use App\Http\Resources\Api\Dentist\RfqBidResource;

class RfqController extends Controller
{
    use HasCrudActions;

    protected $model = RFQ::class;

    protected $resource = RfqResource::class;

    protected $request = RfqRequest::class;


    public function index()
    {


        $modelResource = $this->search()->where('user_id',auth()->user()->id)->with([ 'product:id,name',
        'specs:id,key,value',
        'branch:id,name,location']);
            return $this->apiResponse('200', __('success'), '', RfqResource::collection($modelResource->orderBy('id', 'DESC')->get()));


    }

    public function store()
    {
        try {
            $request = app($this->request);

            DB::beginTransaction();

            // Prepare data to create the record
            $recordData = $request->except('image');

            if(auth()->user()->rfqs()->where('status' , 'pending')->where('order_type' , 'rfq_order')->count() > 0){
                return $this->apiResponse('400', __('fail'), 'you have pending requests');
            }

            // Create the record
            $record = $this->model::create($recordData);
            $record->order_type = 'rfq_order';
            $record->save();
            if($request->has('specs')){
                $record->specs()->attach($request->specs);


            }
            // Create history

            DB::commit();

            // Return response
            $recordResource = new $this->resource($record);
            return $this->apiResponse(Response::HTTP_CREATED, __('success'), __('created successfully'), $recordResource);
        } catch (\Exception $e) {
            DB::rollBack();
            $this->log(0, $this->model, $e->getMessage(),$e);
            return $this->errorMessage($e);
        }
    }


    public function bids()
    {
        // Get the current date in 'Y-m-d' format
        $currentDate = now()->format('Y-m-d');
    
        // Fetch all RfqBids with user_id = authenticated user, is_approved = 0, created today, and RFQ status = 'Pending'
        $bids = RfqBid::where('user_id', auth()->user()->id)
                    ->where('is_approved', 0)
                    ->whereDate('created_at', $currentDate)
                    ->whereHas('rfq', function ($query) {
                        $query->where('status', 'Pending');
                    })
                    ->orderBy('price', 'ASC')
                    ->get();
    
        // Fetch all RfqBids with user_id = authenticated user, is_approved = 1, created today, and RFQ status = 'Pending'
        $approvedBid = RfqBid::where('user_id', auth()->user()->id)
                             ->where('is_approved', 1)
                             ->whereDate('created_at', $currentDate)
                             ->whereHas('rfq', function ($query) {
                                 $query->where('status', 'Pending');
                             })
                             ->get();
    
        // Check if there are any approved bids
        if ($approvedBid->isNotEmpty()) {
            // Return the approved bid(s)
            return $this->apiResponse(Response::HTTP_CREATED, __('success'), '', RfqBidResource::collection($approvedBid));
        }
    
        // Return unapproved bids if no approved bids are found
        return $this->apiResponse(Response::HTTP_CREATED, __('success'), '', RfqBidResource::collection($bids));
    }
    
    public function AcceptBid($id)
    {
        try {
            $bid = RfqBid::find($id);
            $rfq = RFQ::find($bid->rfq_id);
            if($bid && $bid->user_id == auth()->user()->id){
                $bid->is_approved = 1;
                // $rfq->vendor_id = $bid->vendor_id;
                $rfq->price = $bid->price;

                $rfq->is_approved = 1;
                $rfq->save();
                $bid->save();
                return $this->apiResponse(Response::HTTP_CREATED, __('success'), __('Bid Accepted Successfully'), RfqBidResource::make($bid));
            }

            return $this->errorMessage(__('You are not authorized to accept this bid'));

        } catch (\Exception $e) {
            $this->log(0, $this->model, $e->getMessage(), $e);
            return $this->errorMessage($e);
        }
    }

    public function CancelRfq($id)
    {
        $rfq = RFQ::where(['id' => $id , 'user_id' => Auth::id()])->first();
        if(!$rfq){
            return $this->apiResponse(Response::HTTP_OK, 'fail', __('resource not found'));
        }
            
        $rfq->update([
            'status' => 'cancelled',
        ]);
        return $this->apiResponse(Response::HTTP_OK, __('success'), __('RFq Cancelled successfully'));
    }
}
