<?php

namespace App\Http\Controllers\Api;

use App\Models\User;
use App\helpers\Attachment;
use App\Traits\ApiResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\BankAccountRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Http\Requests\Api\ProfileRequest;
use App\Http\Resources\Api\ProfileResource;
use App\Models\BankAccount;

class ProfileController extends Controller
{
    use ApiResponse;

    public function MyProfile(Request $request)
    {
        $user = auth()->user()->load(['branches' , 'bankAccount']);
        return $this->apiResponse(200, 'success', '', new ProfileResource($user));
    }


    public function update(ProfileRequest $request)
    {
        $user = Auth::user();
        $user->update($request->except(['image']));



        if ($request->hasFile('image')) {
            Attachment::updateAttachment($request->file('image'), $user->image,$user, 'users/profile', ['save' => 'original', 'usage' => 'image']);
        }

        return $this->ApiResponse(
            '200',
            __('success'),
            __('Profile Settings Updated Successfully'),
            new ProfileResource($user)
        );
    }



    public function updateProfilePassword(Request $request)
    {
        $this->validate($request, [
            'old_password' => 'required',
            'password'     => 'required|confirmed',
        ]);

        $user = User::where(['id' => Auth::user()->id])->first();

        if (Hash::check($request->old_password, $user->password)) {
            if (Hash::check($request->password, $user->password)) {
                return $this->ApiResponse('400', 'failed',__('new password cannot be same as current password'),  );
            }
            $user->password = Hash::make($request->password);
            $user->save();

            return $this->ApiResponse('200', __('success'),  __('Password changed successfully.'));
        } else {
            return $this->ApiResponse('400', 'failed', __('Old Password is Wrong!'))  ;
        }
    }

    public function BankAccount(BankAccountRequest $request)
    {
        $user = Auth::user();

        $bankAccount = BankAccount::updateOrCreate(
            ['user_id' => $user->id], // Match on user_id
            [
                'bank_account' => $request->input('bank_account'),
                'bank_holder_name' => $request->input('bank_holder_name'),
                'bank_number' => $request->input('bank_number'),
                'swift_code' => $request->input('swift_code'),
                'iban' => $request->input('iban'),
            ]
        );

        return $this->ApiResponse('200', __('success'),  __('Data Updated successfully.'));

    }

    public function deleteAccount()
    {
        // Get the authenticated user
        $user = Auth::user();

        if (!$user) {
            return $this->apiResponse(
                404,
                __('User not found'),
                ''
            );
        }

        $user->delete();



        return $this->apiResponse(
            200,
            __('Account deleted successfully'),
            ''
        );
    }


}
