<?php

namespace App\Http\Controllers\Api\vendor;

use App\Models\Branch;
use Illuminate\Http\Request;
use App\Traits\HasCrudActions;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Requests\Api\Client\BranchRequest;
use App\Http\Resources\Api\Client\BranchResource;

class BranchController extends Controller
{
    use HasCrudActions;


    protected $model = Branch::class;

    protected $resource = BranchResource::class;

    protected $request = BranchRequest::class;


    public function index()
    {
        $model = app($this->model);

        // Use the method to retrieve relations for eager loading
        $relations = method_exists($model, 'getWithRelations') ? $model->getWithRelations() : [];

        $modelResource = $this->search()->with($relations);
            return $this->apiResponse('200', __('success'), '', $modelResource->where('user_id' , Auth::id())->orderBy('id', 'DESC')->get());


    }


    public function destroy(string $id )
    {
        try {
            $record = $this->model::find($id);
            if (!$record) {
                return $this->apiResponse(Response::HTTP_OK, 'fail', __('resource_not_found'));
            }

            DB::beginTransaction();

            if($record->rfq){
                return $this->apiResponse(400, __('fail'), __('cant delete resource'));

            }
            $record->delete();

            DB::commit();

            return $this->apiResponse(Response::HTTP_OK, __('success'), __('deleted successfully'));
        } catch (\Exception $e) {

            DB::rollBack();

            $this->log($id, $this->model, $e->getMessage(),$e);

            return $this->errorMessage($e);
        }
    }

}
