<?php

namespace App\Http\Requests\Api\Admin;

use Illuminate\Foundation\Http\FormRequest;

class BranchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['required','string','max:255'],
            'location' => ['required','string','max:255'],
            'mobile' => ['required','numeric'],
            'country_code' => ['required'],
            'city_id' => ['required' , 'exists:cities,id'],
            'governerate_id' => ['required' , 'exists:governorates,id'],
        ];
    }
}
