<?php



namespace App\Models;

use App\Traits\GetAttribute;
use Carbon\Carbon;
use App\Traits\Notificationable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Laravel\Sanctum\HasApiTokens;

class Admin extends Authenticatable
{
   use  HasApiTokens,Notificationable , Notifiable , GetAttribute;
	protected $table = 'admins';

	protected $casts = [
		'role_id' => 'int',
		'birth_date' => 'datetime',
		'national_id' => 'int',
		'email_verified_at' => 'datetime'
	];

	protected $hidden = [
		'password'
	];

	protected $fillable = [
		'username',
		'email',
		'password',
		'phone',
		'mobile',
		'first_name',
		'second_name',
		'third_name',
		'last_name',
		'role_id',
		'status',
		'martial_status',
		'gender',
		'birth_date',
		'national_id',
		'email_verified_at'
	];


    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->multiple_attachment = true;
        $this->multiple_attachment_usage = ['default', 'bdf-file'];
    }


    public function getImageAttribute()
    {
        return $this->attachmentRelation()->first();
    }

	public function fcmTokens()
{
    return $this->morphMany(FcmToken::class, 'user');
}


	public function bankAccount()
{
    return  $this->hasOne(BankAccount::class);
}









}
