<?php


namespace App\Models;

use App\Traits\SearchableRelations;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Astrotomic\Translatable\Translatable;

class City extends Model
{

    use Translatable , SearchableRelations;

	protected $table = 'cities';

	protected $casts = [
		'status' => 'bool',
		'country_id' => 'int',
		'governerate_id' => 'int'
	];

	protected $fillable = [
		'status',
		'country_id',
		'governerate_id'
	];

    public $translatedAttributes = [
		'name',
	];

	public function country()
	{
		return $this->belongsTo(Country::class);
	}

	public function governerate()
	{
		return $this->belongsTo(Governerate::class);
	}

    public function city_translations()
	{
		return $this->hasMany(CityTranslation::class);
	}

}
