<?php


namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class GovernerateTranslation extends Model
{
	protected $table = 'governorate_translations';

	protected $casts = [
		'governerate_id' => 'int'
	];

    protected $fillable = ['governerate_id', 'name'];


	public function governerate()
	{
		return $this->belongsTo(Governerate::class , 'governerate_id');
	}

    public function gov_translations()
	{
		return $this->hasMany(GovernerateTranslation::class);
	}

}
