<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rfqs_specs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('rfq_id')->constrained('r_f_q_s')->cascadeOnDelete();
            $table->foreignId('spec_id')->constrained('specs')->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rfqs_specs');
    }
};
