<?php

use App\Exports\UserExport;
use App\Exports\OrdersExport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PaymobWebhookController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});
Route::get('api/orders/export/{type}', function ($type) {
    $validTypes = ['direct_order', 'rfq_order', 'orders'];

    if (!in_array($type, $validTypes)) {
        abort(404, "Invalid order type.");
    }

    return Excel::download(new OrdersExport($type), "{$type}_orders.xlsx");
});

Route::get('api/users/export/{type}', function ($type) {
    $validTypes = ['dentist', 'vendor', 'employee'];

    if (!in_array($type, $validTypes)) {
        abort(404, "Invalid user type.");
    }

    return Excel::download(new UserExport($type), "{$type}_users.xlsx");
});

Route::any('Paymob/webhook' , [PaymobWebhookController::class , 'handle']);
Route::any('Paymob/callback' ,[ PaymobWebhookController::class , 'handleSuccessfulPayment']);


