<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Request;
use App\Http\Resources\MediaResource;
use Illuminate\Http\Resources\Json\JsonResource;

class LoginResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        if($request->type == 'user'){
            return [
                'id' => $this->id,
                'owner_name' => $this->owner_name,
                'email' => $this->email,
                'country' => $this->whenLoaded('country', function () {
                    return [
                        'id' => $this->country->id,
                        'name' => $this->country->name,
                    ];
                }),
                'mobile' => $this->mobile,
                'image' =>MediaResource::make($this->image),
                'product_access' => $this->product_access,
                'status' => $this->status,

                'email_verified_at' => $this->email_verified_at,
                'type' => $this->type,
            ];
        }

        return [
            'id' => $this->id,
           'name' => $this->name,
           'email' => $this->email,
           'image' => MediaResource::make($this->image),

        ];
    }
}
