<?php

namespace App\Http\Controllers\Api;

use App\Models\User;
use Illuminate\Http\Request;
use App\Traits\HasCrudActions;
use App\Http\Controllers\Controller;
use App\Notifications\CustomNotification;
use Illuminate\Support\Facades\Notification;
use App\Http\Resources\Api\NotificationResource;

class NotificationController extends Controller
{
    use HasCrudActions;
    // Fetch all notifications
    public function index()
    {
        $notifications = auth()->user()->notifications;

        return $this->apiResponse('200', __('success'), '', NotificationResource::collection($notifications));
    }

    // Send a notification
    public function send(Request $request)
    {
        $request->validate([
            'user_id' => 'required|exists:users,id',
            'title' => 'required|string',
            'message' => 'required|string',
        ]);

        $notification = Notification::create($request->all());

        return $this->apiResponse('201', __('Notification sent successfully'), '', $notification);
    }

    // Mark a specific notification as read
    public function markAsRead($id)
    {
        $notification = auth()->user()->notifications()->find($id);

        if (!$notification) {
            return $this->apiResponse('400', '', __('Notification not found'));
        }

        $notification->markAsRead();

        return $this->apiResponse('200','' , __('Notification marked as read'));
    }

    // Mark all notifications as read
    public function markAllAsRead()
    {
        auth()->user()->unreadNotifications->markAsRead();

        return $this->apiResponse('200', __('All notifications marked as read'));
    }

    // Delete a specific notification
    public function delete($id)
    {
        $notification = auth()->user()->notifications()->find($id);

        if (!$notification) {
            return $this->apiResponse('404', __('Notification not found'), 'Not Found');
        }

        $notification->delete();

        return $this->apiResponse('200', __('Notification deleted successfully'));
    }

    // Delete all notifications
    public function deleteAll()
    {
        auth()->user()->notifications()->delete();

        return $this->apiResponse('200', __('All notifications deleted successfully'));
    }
}
