<?php

namespace App\Http\Controllers\Dentist;

use App\Models\User;
use Illuminate\Http\Request;
use App\Traits\HasCrudActions;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Requests\Dentist\EmployeeRequest;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Resources\Dentist\EmployeeResource;

class EmployeeController extends Controller
{
    use HasCrudActions;

    protected $model = User::class;

    protected $resource = EmployeeResource::class;

    protected $request = EmployeeRequest::class;


    public function index()
    {
        $model = app($this->model);

        // Use the method to retrieve relations for eager loading

        $modelResource = $this->search()->where('type' , 'employee')->where('dentist_id' , auth()->user()->id)->with('EmBranch:id,name');

        return $this->apiResponse('200', __('success'), '', EmployeeResource::collection($modelResource->orderBy('id', 'DESC')->get()));



    }

    public function destroy($id)
    {
        try {
            $record = $this->model::find($id);

            $record->delete();

            DB::commit();

            return $this->apiResponse(Response::HTTP_OK, __('success'), __('deleted successfully'));
        } catch (\Exception $e) {

            DB::rollBack();

            $this->log($id, $this->model, $e->getMessage(),$e);

            return $this->errorMessage($e);
        }
    }


}
