<?php

namespace App\Http\Requests\Api\Dentist;

use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Http\FormRequest;

class CardRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            // 'user_id' is removed because we will automatically use the authenticated user
            'card_number' => 'required|string|min:16|max:19', // Adjust as needed
            'payment_method' => 'required|in:master_card,visa,paybal',
            'holder_name' => 'required|string|max:255',
            'expiry_date' => 'required|date_format:m/y',
            'cvv' => 'required|digits:3',
        ];
    }

    /**
     * Modify the validated data before returning it to the controller.
     */
    protected function prepareForValidation()
    {
        // Automatically add the authenticated user's ID to the request data
        $this->merge([
            'user_id' => Auth::id(),
        ]);
    }
}
