<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('countries', function (Blueprint $table) {
            $table->id();
            $table->char('abbreviation', 2);
            $table->string('code');
            $table->string('flag')->nullable();
            $table->string('currency_symbol')->nullable();
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamps();
            $table->softDeletes();
            $table->boolean('is_default')->default(0);

        });

        Schema::create('country_translations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('country_id')->constrained('countries')->onDelete('cascade');
            $table->string('name');
            $table->string('currency')->nullable();
            $table->string('locale')->index();
            $table->unique(['country_id', 'locale']);
        });
    }


    public function down(): void
    {
        Schema::dropIfExists('countries');
        Schema::dropIfExists('country_translations');
    }
};
