<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paymob_payment_trackers', function (Blueprint $table) {
            $table->id();
            $table->string("order_id")->index()->nullable();
            $table->string("reference_id")->index()->nullable();
            $table->foreignId('user_id')->nullable()->constrained('users')->onDelete('cascade');
            $table->unsignedBigInteger("currency_id")->nullable();
            $table->unsignedBigInteger("payment_method_id")->nullable();
            $table->unsignedBigInteger("transaction_id")->nullable();
            $table->decimal("amount", 10, 2)->nullable();
            $table->string("status")->nullable();
            $table->string("message")->nullable();
            $table->json("payload")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paymob_payment_trackers');
    }
};
