<?php

namespace App\Http\Requests\Api\Dentist;

use Illuminate\Foundation\Http\FormRequest;

class RfqRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    protected function prepareForValidation()
    {
        $this->merge([
            'user_id' => auth()->user()->id, // Set default value to 1 if not provided
            'order_type' =>'rfq_order', // Set default value to 1 if not provided


        ]);
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'product_id' => 'required|exists:products,id',
            'price' => 'required|min:0',
            'qty' => 'required|min:0',
            'specs' => ['nullable', 'array'],
            'specs.*' => ['exists:specs,id'],
            'branch_id' => ['required', 'exists:branches,id'],
        ];
    }
}
