<?php

namespace App\Http\Resources\Api\Admin;

use App\Http\Resources\Api\Client\BranchResource;
use Illuminate\Http\Request;
use App\Http\Resources\MediaResource;
use App\Http\Resources\CountryResource;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'owner_name' => $this->owner_name,
            'email' => $this->email,
            'mobile' => $this->mobile,
            'type' => $this->type,
            'country_code' => $this->country_code,
            'product_access' => $this->product_access,
            'status' => $this->status,
            'country' => CountryResource::make($this->country),
            'image' => MediaResource::make($this->image),
            'branches' => $this->when($this->type != 'employee' ,BranchResource::collection($this->branches)),
            'branch' => $this->when($this->type == 'employee' ,BranchResource::make($this->EmBranch) ),
            'bank_info' =>  $this->bankAccount
        ];
    }
}
