<?php

namespace App\Http\Resources\Api\vendor;

use App\Http\Resources\MediaResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SubCategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'category' => $this->parent?->name,
            'image' => MediaResource::make($this->image),

            'main_category_id' => $this->main_category_id,
            'sub_categories' => SubCategoryResource::collection($this->children)

        ];
    }
}
