<?php


namespace App\Models;

use Carbon\Carbon;
use App\Traits\GetAttribute;
use App\Traits\SearchableRelations;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Laravel\Sanctum\HasApiTokens;
use Spatie\MediaLibrary\HasMedia;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\InteractsWithMedia;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasApiTokens, GetAttribute , SearchableRelations , Notifiable;

    protected $table = 'users';

    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed'

    ];

    protected $hidden = [
        'password',
        'remember_token'
    ];

    protected $fillable = [
        'email',
        'email_verified_at',
        'password',
        'remember_token',
        'mobile',
        'type',
        'vendor_id',
        'product_access',
        'role_name',
        'branch_id',
        'country_code',
        'owner_name',
        'country_id',
        'status',
        'product_access',
        'dentist_id'

    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->multiple_attachment = true;
        $this->multiple_attachment_usage = ['default', 'bdf-file'];
    }


    public function getImageAttribute()
    {
        return $this->attachmentRelation()->first();
    }

public function branches()
{
    return  $this->hasMany(Branch::class);
}

public function bankAccount()
{
    return  $this->hasOne(BankAccount::class);
}

public function favoriteProducts()
    {
        return $this->belongsToMany(Product::class, 'favourites')->withTimestamps();
    }

public function country()
{
    return $this->belongsTo(Country::class, 'country_id');
}

public function fcmTokens()
{
    return $this->morphMany(FcmToken::class, 'user');
}

    public function createNewUser($request, $intiatedBy)
    {
        $user = new self();
        if ($intiatedBy == 'user') {
            $user->type = $request->type;
        }

        $user->email      = $request->email;
        $user->mobile      = $request->mobile;
        $user->country_code      = $request->country_code;
        $user->country_id = $request->country_id;
        $user->password = Hash::make($request->password);
        $user->type = $request->type;
        $user->owner_name = $request->owner_name;
        $user->save();

        return $user;
    }

    public function EmBranch()
    {
        return $this->belongsTo(Branch::class , 'branch_id' , 'id');
    }

    public function vendor(){
        return $this->belongsTo(User::class , 'vendor_id');
    }

    public function rfqs()
    {
        return $this->hasMany(RFQ::class);
    }
}
